<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
?>
<style>
.CodeMirror {
	height: 500px;
	width: auto;
	margin: 20px;
}
</style>
<div class="cktitle"><?php echo TCK_Text::_('CK_LAYOUT_EDIT'); ?> : <?php echo TCK_Text::_('CK_ERROR_404'); ?></div>
<div id="ckelementscontainer">
	<div data-id="elementscontent" class="layoutoptions ckproperty" style="width:auto;">
			<div style="text-align:left;clear:both;margin-left:10px;">
				<div style="float:left;text-align:left;width:170px;margin:5px 5px 0 0px;"><?php echo TCK_Text::_('CK_USE_CUSTOM_ERROR404'); ?></div>
				<div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>switch.png" width="15" height="15" align="top" /></div>
				<div style="float:left;text-align:right;">
					<select class="inputbox" type="list" name="error404use" id="error404use" value="" style="width:105px;" onchange="ckError404ToggleUse()" >
						<option value="1"><?php echo TCK_Text::_('CK_YES'); ?></option>
						<option value="0"><?php echo TCK_Text::_('CK_NO'); ?></option>
						<option value="2"><?php echo TCK_Text::_('CK_LINK_REDIRECT'); ?></option>
					</select>
				</div>
				<span> <i><?php echo TCK_Text::_('CK_USE_CUSTOM_ERROR404_DESC'); ?></i></span>
				<div class="clr"></div>
			</div>
			<div id="tab_error404_link" style="display: none;">
				<p><a href="https://www.template-creator.com/fr/documentation-category/options/create-a-404-redirection" target="_blank"><?php echo TCK_Text::_('CK_ERROR404_LINK_REDIRECT_DESC'); ?></a></p>
			</div>
			<div id="tab_error404" >
				<div style="text-align:left;clear:both;margin-left:10px;">
					<div style="float:left;text-align:left;width:170px;margin:5px 5px 0 0px;"><?php echo TCK_Text::_('CK_CODE_IN_CONTENT'); ?></div>
					<div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>application_parts.png" width="15" height="15" align="top" /></div>
					<div style="float:left;text-align:right;">
						<select class="inputbox" type="list" name="error404codeincontent" id="error404codeincontent" value="" style="width:105px;" >
							<option value="1"><?php echo TCK_Text::_('CK_YES'); ?></option>
							<option value="0"><?php echo TCK_Text::_('CK_NO'); ?></option>
						</select>
					</div>
					<span> <i><?php echo TCK_Text::_('CK_CODE_IN_CONTENT_DESC'); ?></i></span>
					<div class="clr"></div>
				</div>
				<div class="ckinterfacetitle"><?php echo TCK_Text::_('CK_CODE'); ?></div>
				<div>
					<table>
						<tr>
							<td style="vertical-align:top;">
								<div style="text-align:left;clear:both;">
									<textarea id="error404custommessage" cols="100" rows="20" style="color: #777;"></textarea>
									<div class="clr"></div>
								</div>
							</td>
							<td style="vertical-align:top;">
								<h3><?php echo TCK_Text::_('CK_DEFAULT_TAGS'); ?></h3>
								<p><?php echo TCK_Text::_('CK_DEFAULT_TAGS_DESC'); ?></p>
								<table class="cktable cktable-bordered">
									<tr><th><?php echo TCK_Text::_('CK_CODE'); ?></th><th><?php echo TCK_Text::_('CK_DESCRIPTION'); ?></th></tr>
									<tr><td>{ERROR_REQUEST}</td><td><?php echo TCK_Text::_('CK_ERROR404_ERROR_REQUEST'); ?></td></tr>
									<tr><td>{SEARCH_FIELD}</td><td><?php echo TCK_Text::_('CK_ERROR404_SEARCH_FIELD'); ?></td></tr>
									<tr><td>{GO_HOME}</td><td><?php echo TCK_Text::_('CK_ERROR404_GO_HOME'); ?></td></tr>
									<tr><td>{ERROR_MESSAGE}</td><td><?php echo TCK_Text::_('CK_ERROR404_ERROR_MESSAGE'); ?></td></tr>
									<tr><td>{ERROR_CODE}</td><td><?php echo TCK_Text::_('CK_ERROR404_ERROR_CODE'); ?></td></tr>
									<tr><td>{CONTACT_ADMINISTRATOR}</td><td><?php echo TCK_Text::_('CK_ERROR404_CONTACT_ADMINISTRATOR'); ?></td></tr>
								</table>
							</td>
						</tr>
					</table>
				</div>
			</div>

	</div>
</div>
<script language="javascript" type="text/javascript">
	$ck('#elementscontent div.tab:not(.current)').hide();
	$ck('.menulink', $ck('#ckelementscontainer')).each(function(i, tab) {
		$ck(tab).click(function() {
			$ck('#elementscontent div.tab').hide();
			$ck('.menulink', $ck('#ckelementscontainer')).removeClass('current');
			if ($ck('#' + $ck(tab).attr('tab')).length)
				$ck('#' + $ck(tab).attr('tab')).show();
			$ck(this).addClass('current');
		});
	});

	$ck('#elementscontent div.tab2:not(.current)').hide();
	$ck('.menulink2', $ck('#ckelementscontainer')).each(function(i, tab) {
		$ck(tab).click(function() {
			$ck('#elementscontent div.tab2').hide();
			$ck('.menulink2', $ck('#ckelementscontainer')).removeClass('current');
			if ($ck('#' + $ck(tab).attr('tab')).length)
				$ck('#' + $ck(tab).attr('tab')).show();
			$ck(this).addClass('current');
		});
	});

	$ck('#elementscontent div.tab3:not(.current)').hide();
	$ck('.menulink3', $ck('#ckelementscontainer')).each(function(i, tab) {
		$ck(tab).click(function() {
			var p = $ck(this).parent();
			$ck('.tab3', p).hide();
			$ck('.menulink3', p).removeClass('current');
			if ($ck('#' + $ck(tab).attr('tab')).length)
				$ck('#' + $ck(tab).attr('tab')).show();
			$ck(this).addClass('current');
		});
	});

	var editor_error404custommessage;

	function ckError404ToggleUse() {
		var use = $ck('#error404use').val();
		if (use == '1') {
			$ck('#tab_error404').show();
			$ck('#tab_error404_link').hide();
		} else if (use == '2') {
			$ck('#tab_error404').hide();
			$ck('#tab_error404_link').show();
		} else {
			$ck('#tab_error404').hide();
			$ck('#tab_error404_link').hide();
		}
		if (editor_error404custommessage) editor_error404custommessage.save(); 
	}

	ckInitColorPickers();
	ckInitModalPopup();
	ckInitOptionsAccordions();

	
	// Autoloaded function after edition filled and preview
	function ckUpdateLayoutPreviewerror404() {
		
		// ckError404ToggleCodeincontent();

		// get the html code and css code 
		var error404custommessage = $ck('#layout_error404_html .error404custommessage').html();
		if (! error404custommessage) {
			error404custommessage = '<header class="page-header">' + "\n\t"
										+'<h1 class="page-title">' + "\n\t\t"
											+'{ERROR_REQUEST}' + "\n\t"
										+'</h1>' + "\n"
									+'</header>' + "\n"
									+'<div class="page-content">' + "\n\t"
										+'<p>' + "\n\t\t"
											+'{SEARCH_FIELD}' + "\n\t"
										+'</p>' + "\n\t"
										+'<p>' + "\n\t\t"
											+'{GO_HOME}' + "\n\t"
										+'</p>' + "\n"
									+'</div>' + "\n"
									+'<hr />' + "\n"
									+'<p>{CONTACT_ADMINISTRATOR}</p>' + "\n"
									+'<blockquote>' + "\n\t"
										+'<span class="label label-inverse">{ERROR_CODE}</span> {ERROR_MESSAGE}' + "\n"
									+'</blockquote>';
		}
		error404custommessage = error404custommessage.replace(/&lt;/g, '<').replace(/&gt;/g, '>');
		$ck('#error404custommessage').attr('value', error404custommessage);

		editor_error404custommessage = CodeMirror.fromTextArea(document.getElementById("error404custommessage"), {
			mode: "php",
		//	styleActiveLine: true,
			lineNumbers: true,
		//	lineWrapping: true
		});
		ckError404ToggleUse();
	}

	function ckBeforeSaveLayoutPopuperror404() {
		// store the custom html
		editor_error404custommessage.save(); // save the editor to the textarea
		var error404custommessage = $ck('#error404custommessage').attr('value');
		error404custommessage = error404custommessage.replace(/</g, '&lt;').replace(/>/g, '&gt;');
		if (! $ck('#layout_error404_html .error404custommessage').length) {
			$ck('#layout_error404_html').append('<div class="error404custommessage" style="display:none;"></div>');
		}
		$ck('#layout_error404_html .error404custommessage').html(error404custommessage);
	}
</script>