<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access
defined('TCK_LOADED') or die;

/**
 * Templateck helper.
 */
class TemplateckHelper {

	/**
	 * Configure the Linkbar.
	 */
	public static function addSidebar($vName = '') {
		$input = new TCK_Input();
		if (!$vName) $vName = $input->get('view', 'templates', 'cmd');
		$doc = \Joomla\CMS\Factory::getDocument();
		// load jQuery for joomla 2.5
		if (version_compare(JVERSION, '3.0.0') < 0) {
			$doc->addScript(\Joomla\CMS\Uri\Uri::base(true) . '/components/com_templateck/assets/jquery.min.js');
			$doc->addScript(\Joomla\CMS\Uri\Uri::base(true) . '/components/com_templateck/assets/jquery-noconflict.js');
		}

		if (version_compare(JVERSION, '3.0.0') >= 0 && version_compare(JVERSION, '4.0.0') < 0) {
			JHtmlSidebar::addEntry(
					TCK_Text::_('COM_TEMPLATECK_TITLE_TEMPLATES'), 'index.php?option=com_templateck&view=templates', $vName == 'templates'
			);
			JHtmlSidebar::addEntry(
					TCK_Text::_('CK_SUBMENU_FONTS'), 'index.php?option=com_templateck&view=fonts', $vName == 'fonts'
			);
			JHtmlSidebar::addEntry(
					TCK_Text::_('CK_ABOUT') . '<span class="templateckchecking"></span>', 'index.php?option=com_templateck&view=about', $vName == 'about'
			);
			JHtmlSidebar::addEntry(
					TCK_Text::_('CK_HELP'), 'index.php?option=com_templateck&view=help', $vName == 'help'
			);
			echo '<div class="ckadminsidebar">' . JHtmlSidebar::render() . '</div>';
		}
	
		// add the ajax method to check for an update
		$js_checking = 'jQuery(document).ready(function (){
				jQuery(\'.templateckchecking\').each(function(i ,el){
					jQuery.ajax({
						type: "POST",
						url: \'' . \Joomla\CMS\Uri\Uri::root(true) . '/administrator/index.php?option=com_templateck&task=check_update\',
						data: {
	}
					}).done(function(response) {
						response = response.trim();
						if ( response.substring(0,7).toLowerCase() == \'error\' ) {
							// alert(response);
							// show_ckmodal(response);
						} else {
							jQuery(el).append(response);
	}
					}).fail(function() {
						// alert(Joomla.TCK_Text._(\'CK_FAILED\', \'Failed\'));
					});
				});
			});';
		$doc->addScriptDeclaration($js_checking);
		}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return	\Joomla\CMS\Object\CMSObject
	 * @since	1.6
	 */
	public static function getActions() {
		$user = \Joomla\CMS\Factory::getUser();
		$result = new \Joomla\CMS\Object\CMSObject;

		$assetName = 'com_templateck';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}

	/**
	 * Test if there is already a unit, else add the px
	 *
	 * @param string $value
	 * @return string
	 */
	public static function testUnit($value, $defaultunit = "px") {

		if ((stristr($value, 'px')) 
				OR (stristr($value, 'em')) 
				OR (stristr($value, '%')) 
				OR (stristr($value, 'rem')) 
				OR (stristr($value, 'vh')) 
				OR (stristr($value, 'vw')) 
				OR $value == 'auto'
				)
			return $value;

		return $value . $defaultunit;
	}

	/**
	 * Check the token for security reason
	 * @return boolean
	 */
	public static function checkAjaxToken() {
		if (! \Joomla\CMS\Session\Session::checkToken('get')) {
			$msg = TCK_Text::_('CK_INVALID_TOKEN');
			echo '{"status": "0", "message": "' . $msg . '"}';
			exit();
		}
		return true;
	}

	/*
	 * Load the JS and CSS files needed to use CKBox
	 *
	 * Return void
	 */
	public static function loadCkbox() {
		$doc = \Joomla\CMS\Factory::getDocument();
		$doc->addScript(TEMPLATECREATORCK_MEDIA_URI . '/assets/jquery.min.js');
		$doc->addStyleSheet(TEMPLATECREATORCK_MEDIA_URI . '/assets/ckbox.css');
		$doc->addScript(TEMPLATECREATORCK_MEDIA_URI . '/assets/ckbox.js');
	}

	/*
	 * Load the JS and CSS files needed to use CKBox
	 *
	 * Return void
	 */
	public static function loadCKFramework() {
		$doc = \Joomla\CMS\Factory::getDocument();
		$doc->addScript(TEMPLATECREATORCK_MEDIA_URI . '/assets/jquery.min.js');
		$doc->addStyleSheet(TEMPLATECREATORCK_MEDIA_URI . '/assets/ckframework.css');
	}

	/*
	 * Load the JS and CSS files needed to use CKBox
	 *
	 * Return void
	 */
	/*public static function loadInlineCKFramework() {
	?>
		<script src="<?php echo \Joomla\CMS\Uri\Uri::root(true) ?>/media/jui/js/jquery.min.js" type="text/javascript"></script>
		<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckframework.css" type="text/css" />
	<?php
	}*/

	/*
	 * Replace the variables to store the file
	 * 
	 * @return string, the json encoded item
	 */
	public static function getExportFile($item) {
		$item->htmlcode = str_replace(TEMPLATECREATORCK_URI_ROOT, "|URIROOT|", $item->htmlcode);
		$exportfiletext = json_encode($item);

		return $exportfiletext;
	}

	/**
	 * Give the file directly for download in the browser
	 * 
	 * @param type $file
	 */
	public static function pushFileForDownload($filepath, $ext = 'zip') {
		$filepath = TEMPLATECREATORCK_PATH . $filepath;
		$filename = basename($filepath);
		header('Content-type: application/' . $ext);
		header("Content-Disposition: attachment; filename=$filename");                             
		header("Content-Length: " . filesize($filepath));

		readfile($filepath);

		exit();
	}

	/**
	 * Utility function to map an array to a stdClass object.
	 *
	 * @param   array    $array      The array to map.
	 * @param   string   $class      Name of the class to create
	 * @param   boolean  $recursive  Convert also any array inside the main array
	 *
	 * @return  object
	 *
	 * @since   1.0
	 */
	public static function toObject(array $array, $class = 'stdClass', $recursive = true)
	{
		$obj = new $class;

		foreach ($array as $k => $v)
		{
			if ($recursive && is_array($v))
			{
				$obj->$k = static::toObject($v, $class);
			}
			else
			{
				$obj->$k = $v;
			}
		}

		return $obj;
	}

	public static function getToken() {
		return \Joomla\CMS\Session\Session::getFormToken();
	}

	public static function checkToken() {
		// Check for request forgeries.
		\Joomla\CMS\Session\Session::checkToken() or jexit(TCK_Text::_('JINVALID_TOKEN'));
	}

	public static function redirect($url) {
		$app = \Joomla\CMS\Factory::getApplication();
		$app->redirect($url);
	}

	public static function displayMessages() {
		foreach (\Joomla\CMS\Factory::getApplication()->getMessageQueue() as $messageArr) {
			if ($messageArr['message']) { 
			$type = $messageArr['type'] = 'message' ? 'success' : $messageArr['type'];
			?>
				<div class="ckalert ckalert-<?php echo $type ?>">
					<div class="ckclose" onclick="$ck(this).parent().remove();">×</div>
					<p><?php echo $messageArr['message'] ?></p>
				</div>
			<?php
			}
		}
	}

	/**
	 * Create the list of all modules published as Object
	 *
	 * $file string the image path
	 * $x integer the new image width
	 * $y integer the new image height
	 *
	 * @return Boolean True on Success
	 */
	static function resizeImage($file, $x, $y = '', $thumbpath = 'th', $thumbsuffix = '_th') {

		if (!$file)
			return;

		$thumbext = explode(".", $file);
		$thumbext = end($thumbext);
		$thumbfile = str_replace(basename($file), $thumbpath . "/" . basename($file), $file);
		$thumbfile = str_replace("." . $thumbext, $thumbsuffix . "." . $thumbext, $thumbfile);
		
		$filetmp = $file;
		$filetmp = str_replace("%20", " ", $filetmp);

		if (!file_exists($filetmp))
			return;
		$size = getimagesize($filetmp);

		if ($size[0] > $size[1] || ! $y) // paysage
		{
			$y = $x * $size[1] / $size[0];
		} else 
		{
//			$tmpx = $x;
//			$x = $y;
//			$y = $tmpx * $size[0] / $size[1];
			$x = $y * $size[0] / $size[1];
		}

		// serve integer value
		$x = (int)$x;
		$y = (int)$y;

		if ($size) {
			// if (file_exists($thumbfile)) {
				// return $thumbfile;
				// $thumbsize = getimagesize(JPATH_ROOT . '/' . $thumbfile);
				// if ($thumbsize[0] == $x || $thumbsuffix == '') {
					// return $thumbfile;
				// }
			// }
			
			$thumbfolder = str_replace(basename($file), $thumbpath . "/", $filetmp);
			if (!file_exists($thumbfolder)) { 
				TCK_Folder::create($thumbfolder);
				// TCK_File::copy(JPATH_ROOT . '/modules/mod_slideshowck/index.html', $thumbfolder . 'index.html' );
			}

			if ($size['mime'] == 'image/jpeg') {
				$img_big = imagecreatefromjpeg($filetmp); # On ouvre l'image d'origine
				$img_new = imagecreate($x, $y);
				# création de la miniature
				$img_mini = imagecreatetruecolor($x, $y) or $img_mini = imagecreate($x, $y);
				// copie de l'image, avec le redimensionnement.
				imagecopyresized($img_mini, $img_big, 0, 0, 0, 0, $x, $y, $size[0], $size[1]);

				imagejpeg($img_mini, $thumbfile);
			} else if ($size['mime'] == 'image/png') {
				$img_big = imagecreatefrompng($filetmp); # On ouvre l'image d'origine
				$img_new = imagecreate($x, $y);
				# création de la miniature
				$img_mini = imagecreatetruecolor($x, $y) or $img_mini = imagecreate($x, $y);
				// copie de l'image, avec le redimensionnement.
				imagecopyresized($img_mini, $img_big, 0, 0, 0, 0, $x, $y, $size[0], $size[1]);

				imagepng($img_mini, $thumbfile);
			} else if ($size['mime'] == 'image/gif') {
				$img_big = imagecreatefromgif($filetmp); # On ouvre l'image d'origine
				$img_new = imagecreate($x, $y);
				# création de la miniature
				$img_mini = imagecreatetruecolor($x, $y) or $img_mini = imagecreate($x, $y);
				// copie de l'image, avec le redimensionnement.
				imagecopyresized($img_mini, $img_big, 0, 0, 0, 0, $x, $y, $size[0], $size[1]);

				imagegif($img_mini, $thumbfile);
			}
		}

		return $thumbfile;
	}

	public static function renderInterfaceSliderTitle($text, $desc = '', $func = '') {
		if ($desc) {
			$desc = '<span class="ckleftpanelsubtitle ckleftpanelsubtitleunder">' . TCK_Text::_($desc) . '</span>';
		}
		?>
		<div class="ckinterfacesliderback" <?php echo ($func ? 'onmousedown="' . $func . '()"' : '') ?>>
			<button class="ckinterfaceslider-back-button" tabindex="0" >
			</button>
			<div class="ckinterfaceslidertitle"><?php echo TCK_Text::_($text) . $desc?></div>
		</div>
		<?php
	}

	public static function renderInterfaceMainTitle($text, $icon) {
		?>
		<div class="ckinterfacemainheader">
			<button class="ckinterfacemainheader-icon" tabindex="0">
				<i class="fack <?php echo $icon ?>"></i>
			</button>
			<div class="ckinterfacemainheader-title"><?php echo TCK_Text::_($text) ?></div>
		</div>
		<?php
	}

	public static function renderNoNameMessage() {
		?>
		<div class="ckalert"><?php echo TCK_Text::_('CK_TEMPLATE_MUST_HAVE_NAME') ?></div>
		<?php
	}

	/**
	 * Function to replace the PHP function since PHP 8.2
	 * @param type $string the string to encode
	 */
	public static function utf8_encode($string) {
		return iconv('ISO-8859-1', 'UTF-8', $string);
	}

	/**
	 * Transform the old FA class into SVG icon
	 * 
	 * @param type $icon
	 * @return array
	 */
	public static function getSvgIconFromFont($icon) {
		$list = array(
			'fack-mobile' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M272 0H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h224c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zM160 480c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm112-108c0 6.6-5.4 12-12 12H60c-6.6 0-12-5.4-12-12V60c0-6.6 5.4-12 12-12h200c6.6 0 12 5.4 12 12v312z"></path></svg>'
			, 'fack-pencil' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M497.9 142.1l-46.1 46.1c-4.7 4.7-12.3 4.7-17 0l-111-111c-4.7-4.7-4.7-12.3 0-17l46.1-46.1c18.7-18.7 49.1-18.7 67.9 0l60.1 60.1c18.8 18.7 18.8 49.1 0 67.9zM284.2 99.8L21.6 362.4.4 483.9c-2.9 16.4 11.4 30.6 27.8 27.8l121.5-21.3 262.6-262.6c4.7-4.7 4.7-12.3 0-17l-111-111c-4.8-4.7-12.4-4.7-17.1 0zM124.1 339.9c-5.5-5.5-5.5-14.3 0-19.8l154-154c5.5-5.5 14.3-5.5 19.8 0s5.5 14.3 0 19.8l-154 154c-5.5 5.5-14.3 5.5-19.8 0zM88 424h48v36.3l-64.5 11.3-31.1-31.1L51.7 376H88v48z"></path></svg>'
			, 'fack-cog' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M487.4 315.7l-42.6-24.6c4.3-23.2 4.3-47 0-70.2l42.6-24.6c4.9-2.8 7.1-8.6 5.5-14-11.1-35.6-30-67.8-54.7-94.6-3.8-4.1-10-5.1-14.8-2.3L380.8 110c-17.9-15.4-38.5-27.3-60.8-35.1V25.8c0-5.6-3.9-10.5-9.4-11.7-36.7-8.2-74.3-7.8-109.2 0-5.5 1.2-9.4 6.1-9.4 11.7V75c-22.2 7.9-42.8 19.8-60.8 35.1L88.7 85.5c-4.9-2.8-11-1.9-14.8 2.3-24.7 26.7-43.6 58.9-54.7 94.6-1.7 5.4.6 11.2 5.5 14L67.3 221c-4.3 23.2-4.3 47 0 70.2l-42.6 24.6c-4.9 2.8-7.1 8.6-5.5 14 11.1 35.6 30 67.8 54.7 94.6 3.8 4.1 10 5.1 14.8 2.3l42.6-24.6c17.9 15.4 38.5 27.3 60.8 35.1v49.2c0 5.6 3.9 10.5 9.4 11.7 36.7 8.2 74.3 7.8 109.2 0 5.5-1.2 9.4-6.1 9.4-11.7v-49.2c22.2-7.9 42.8-19.8 60.8-35.1l42.6 24.6c4.9 2.8 11 1.9 14.8-2.3 24.7-26.7 43.6-58.9 54.7-94.6 1.5-5.5-.7-11.3-5.6-14.1zM256 336c-44.1 0-80-35.9-80-80s35.9-80 80-80 80 35.9 80 80-35.9 80-80 80z"></path></svg>'
			, 'fack-hand-pointer-o' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M448 240v96c0 3.084-.356 6.159-1.063 9.162l-32 136C410.686 499.23 394.562 512 376 512H168a40.004 40.004 0 0 1-32.35-16.473l-127.997-176c-12.993-17.866-9.043-42.883 8.822-55.876 17.867-12.994 42.884-9.043 55.877 8.823L104 315.992V40c0-22.091 17.908-40 40-40s40 17.909 40 40v200h8v-40c0-22.091 17.908-40 40-40s40 17.909 40 40v40h8v-24c0-22.091 17.908-40 40-40s40 17.909 40 40v24h8c0-22.091 17.908-40 40-40s40 17.909 40 40zm-256 80h-8v96h8v-96zm88 0h-8v96h8v-96zm88 0h-8v96h8v-96z"></path></svg>'
			, 'fack-magic' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M224 96l16-32 32-16-32-16-16-32-16 32-32 16 32 16 16 32zM80 160l26.66-53.33L160 80l-53.34-26.67L80 0 53.34 53.33 0 80l53.34 26.67L80 160zm352 128l-26.66 53.33L352 368l53.34 26.67L432 448l26.66-53.33L512 368l-53.34-26.67L432 288zm70.62-193.77L417.77 9.38C411.53 3.12 403.34 0 395.15 0c-8.19 0-16.38 3.12-22.63 9.38L9.38 372.52c-12.5 12.5-12.5 32.76 0 45.25l84.85 84.85c6.25 6.25 14.44 9.37 22.62 9.37 8.19 0 16.38-3.12 22.63-9.37l363.14-363.15c12.5-12.48 12.5-32.75 0-45.24zM359.45 203.46l-50.91-50.91 86.6-86.6 50.91 50.91-86.6 86.6z"></path></svg>'
			, 'fack-th' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M149.333 56v80c0 13.255-10.745 24-24 24H24c-13.255 0-24-10.745-24-24V56c0-13.255 10.745-24 24-24h101.333c13.255 0 24 10.745 24 24zm181.334 240v-80c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.256 0 24.001-10.745 24.001-24zm32-240v80c0 13.255 10.745 24 24 24H488c13.255 0 24-10.745 24-24V56c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24zm-32 80V56c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.256 0 24.001-10.745 24.001-24zm-205.334 56H24c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24zM0 376v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H24c-13.255 0-24 10.745-24 24zm386.667-56H488c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24zm0 160H488c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24zM181.333 376v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24z"></path></svg>'
			, 'fack-file-code-o' => '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 640 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M278.9 511.5l-61-17.7c-6.4-1.8-10-8.5-8.2-14.9L346.2 8.7c1.8-6.4 8.5-10 14.9-8.2l61 17.7c6.4 1.8 10 8.5 8.2 14.9L293.8 503.3c-1.9 6.4-8.5 10.1-14.9 8.2zm-114-112.2l43.5-46.4c4.6-4.9 4.3-12.7-.8-17.2L117 256l90.6-79.7c5.1-4.5 5.5-12.3.8-17.2l-43.5-46.4c-4.5-4.8-12.1-5.1-17-.5L3.8 247.2c-5.1 4.7-5.1 12.8 0 17.5l144.1 135.1c4.9 4.6 12.5 4.4 17-.5zm327.2.6l144.1-135.1c5.1-4.7 5.1-12.8 0-17.5L492.1 112.1c-4.8-4.5-12.4-4.3-17 .5L431.6 159c-4.6 4.9-4.3 12.7.8 17.2L523 256l-90.6 79.7c-5.1 4.5-5.5 12.3-.8 17.2l43.5 46.4c4.5 4.9 12.1 5.1 17 .6z"></path></svg>'
		);

		return $list[$icon];
	}
}
