<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

/*
 * htmlck (divs and font header tags and icon option)
 * With the new advanced parameter it does the same as the html5 chrome
 */
function modChrome_htmlck($module, &$params, &$attribs)
{
	$moduleTag      = $params->get('module_tag', 'div');
	$headerTag      = htmlspecialchars((string)$params->get('header_tag', 'h3'));
	$bootstrapSize  = (int) $params->get('bootstrap_size', 0);
	$moduleClass    = $bootstrapSize != 0 ? ' span' . $bootstrapSize : '';

	// Temporarily store header class in variable
	$headerClass    = $params->get('header_class');
	$headerClass    = ($headerClass) ? ' class="' . htmlspecialchars((string)$headerClass) . ' tck-module-title"' : ' class="tck-module-title"';

	// Icon settings
	$iconpos = (isset($attribs['iconpos']) && $attribs['iconpos']) ? $attribs['iconpos'] : '';
	if (isset($attribs['icon'])) {
		$iconType = $attribs['icon'];
		if ($iconType === 'svg') {
			$iconposstyle = ($iconpos == 'top' || $iconpos == 'bottom') ? 'display:block;' : 'display:inline-block;';
			$fackstyle = ($iconposstyle != '') ? 'style="' . $iconposstyle . '"' : '';
			$svgFile = $attribs['iconpath'];
			$templatePath = dirname(dirname(__FILE__));
			$svgCode = '';
			if (file_exists($templatePath . '/icons/' . $svgFile)) {
				$svgCode = file_get_contents($templatePath . '/icons/' . $svgFile);
			}
			$icon = '<span class="fack" ' . $fackstyle . '>' . $svgCode . '</span>';
		} else {
			$iconsize = (isset($attribs['iconsize']) && $attribs['iconsize']) ? $attribs['iconsize'] : '';
			$iconvpos = (isset($attribs['iconvpos']) && $attribs['iconvpos']) ? 'vertical-align:' . $attribs['iconvpos'] . ';' : '';
			$iconposstyle = ($iconpos == 'top' || $iconpos == 'bottom') ? 'display:block;' : 'display:inline-block;';
			$fackstyle = ($iconposstyle != '') ? 'style="' . $iconposstyle . '"' : '';
			$fastyle = ($iconvpos != '') ? 'style="' . $iconvpos . '"' : '';

			$icon = (isset($attribs['icon']) && $attribs['icon']) ? '<span class="fack ' . $iconsize . '" ' . $fackstyle . '><span class="' . $attribs['icon'] . '" ' . $fastyle . '></span></span>' : '';
		}
	} else {
		$icon = '';
	}

	$title = (bool) $module->showtitle ? $module->title : '';
	$tckedition = \Joomla\CMS\Factory::getApplication()->input->get('tckedition', 0, 'int');

	// title split
	$search = array('[[', ']]');
	$replace = array('<span class="tck-title-split">', '</span>');
	$title = str_replace($search, $replace, $title);

	if (!empty ($module->content)) : ?>
		<<?php echo $moduleTag; ?> class="tck-module moduletable<?php echo htmlspecialchars((string)$params->get('moduleclass_sfx')) . $moduleClass; ?>"<?php echo ($tckedition === 1 ? ' data-id="' . $module->id . '" data-type="' . $module->module . '"' : '') ?>>
			<?php if ((bool) $module->showtitle || $icon) : ?>
				<<?php echo $headerTag . $headerClass . '>' . (($iconpos == 'left' || $iconpos == 'top') ? $icon : '') . $title . (($iconpos == 'right' || $iconpos == 'bottom') ? $icon : ''); ?></<?php echo $headerTag; ?>>
			<?php endif; ?>
				<div class="tck-module-text">
					<?php echo $module->content; ?>
				</div>
		</<?php echo $moduleTag; ?>>
	<?php endif;
}
