<?php
/**
 * @package RSForm! Pro
 * @copyright (C) 2007-2019 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

require_once __DIR__.'/../formlayout.php';

class RSFormProFormLayoutResponsive extends RSFormProFormLayout
{
    public $errorClass      = '';
    public $fieldErrorClass = 'rsform-error';

	public $progressContent = '<div><div class="rsformProgressContainer"><div class="rsformProgressBar" style="width: {percent}%;"><em>{page_lang} <strong>{page}</strong> {of_lang} {total}</em></div></div></div>';
	
	public function __construct() {
		if ($this->getDirection() == 'rtl') {
			$this->progressContent = '<div><div class="rsformProgressContainer"><div class="rsformProgressBar" style="width: {percent}%;"><em>{total} {of_lang} <strong>{page}</strong> {page_lang}</em></div></div></div>';
		}
		$this->progressOverwritten = true;
		parent::__construct();
		
	}
    public function loadFramework() {
        // Load the CSS files
        $this->addStyleSheet('com_rsform/frameworks/responsive/responsive.css');
		
		if ($this->getDirection() == 'rtl') {
			$this->addStyleSheet('com_rsform/frameworks/responsive/responsive-rtl.css');
		}
    }

    public function modifyForm(&$form)
	{
		$form->CSSClass .= ' formResponsive';
	}

    public function generateButton($goto)
    {
        return
            '<div class="formResponsive">'.
                '<button type="button" class="rsform-submit-button rsform-thankyou-button" name="continue" onclick="'.$goto.'">'.Text::_('RSFP_THANKYOU_BUTTON').'</button>'.
            '</div>';
    }
}